/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	SetDrawingName.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CFile.h"
#include "CApplication.h"

//  Set the specified name to active drawing 
HRESULT SetDrawingName(CString drawingName)
{

	START_METHOD("SetDrawingName")

	HRESULT status = CONV_SUCCESS;
	IApplication *pdApplication = NULL;
	
	// Get the application
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	// get active doc.. here it is partdocument
	IDispatch *pActiveDoc = NULL;
	status = pdApplication->GetActiveDoc(&pActiveDoc);
	CHECK_RETURN_STATUS(status)

	IDrawingDocument *activeDoc = CAST(IDrawingDocument, pActiveDoc);

	IDispatch *pDrawing = NULL;
	status = activeDoc->GetDrawing(&pDrawing);
	CHECK_RETURN_STATUS(status)

	IObject *object = CAST(IObject, pDrawing);

	IDispatch *pFile = NULL;
	status = object->GetFile(&pFile);
	CHECK_RETURN_STATUS(status)

	IObjectFile *objectFile = CAST(IObjectFile, pFile);

	BSTR dName = drawingName.AllocSysString(); 
	status = objectFile->SetName(dName);
	CHECK_RETURN_STATUS(status)

	UpdateDrawing(activeDoc);

	END_METHOD("SetDrawingName")
}
